import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import classNames from 'classnames';

const propTypes = {
    labelClass: PropTypes.string,
    label: PropTypes.string.isRequired,
    iconId: PropTypes.string.isRequired,
    t: PropTypes.func,
    iconClass: PropTypes.string,
    svgClass: PropTypes.string,
};

const defaultProps = {
    labelClass: '',
    t: str => str,
    iconClass: '',
    svgClass: '',
};

export function IconComponent({ labelClass, label, iconId, t, iconClass, svgClass }) {
    const LABEL_CLASS = classNames({
        'player-tip': true,
        [labelClass]: (labelClass !== ''),
    });
    const labelSpan = label ? <span className={LABEL_CLASS} data-tip={t(label)} /> : null;

    return (
        <span>
            {labelSpan}
            <span className={iconClass}>
                <svg className={svgClass}>
                    <use xlinkHref={iconId} />
                </svg>
            </span>
        </span>
    );
}

IconComponent.propTypes = propTypes;
IconComponent.defaultProps = defaultProps;

export const Icon = translate()(IconComponent);
