import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';

const propTypes = {
    captionsEnabled: PropTypes.bool.isRequired,
    turnOn: PropTypes.func.isRequired,
    turnOff: PropTypes.func.isRequired,
};

export function CaptionsButton({ captionsEnabled, turnOn, turnOff }) {
    return captionsEnabled ? (
        <Button
            className={'player-button'}
            onClick={turnOff}
        >
            <Icon
                label={'Captions'}
                iconId={'#icon_cc_off'}
            />
        </Button>
    ) : (
        <Button
            className={'player-button'}
            onClick={turnOn}
        >
            <Icon
                label={'Captions'}
                iconId={'#icon_cc_on'}
            />
        </Button>
    );
}

CaptionsButton.propTypes = propTypes;
