import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { Button } from './base-button';
import { Icon } from './base-icon';
import { AVAILABLE, CONNECTING, CONNECTED,
         VALID_CASTING_STATES, UNAVAILABLE } from 'state/chromecast';
import includes from 'lodash/includes';

const propTypes = {
    castingState: PropTypes.string.isRequired,
    onClick: PropTypes.func.isRequired,
};

export function ChromecastButton({ castingState, onClick }) {
    if (
        castingState === UNAVAILABLE ||
        !includes(VALID_CASTING_STATES, castingState)
    ) {
        return null;
    }

    const CLASSNAMES = classNames({
        'player-button': true,
        'pl-control--chromecast': true,
        'pl-chromecast--available': castingState === AVAILABLE,
        'pl-chromecast--connecting': castingState === CONNECTING,
        'pl-chromecast--connected': castingState === CONNECTED,
    });

    return (
        <Button
            className={CLASSNAMES}
            onClick={onClick}
        >
            <Icon
                label={'Chromecast'}
                iconId={'#icon_chromecast_p1'}
            />
            <svg className="pl-icon--chromecast-connected">
                <use xlinkHref="#icon_chromecast_p2" />
            </svg>
            <svg className="pl-icon--chromecast-connecting-A">
                <use xlinkHref="#icon_chromecast_p3" />
            </svg>
            <svg className="pl-icon--chromecast-connecting-B">
                <use xlinkHref="#icon_chromecast_p4" />
            </svg>
            <svg className="pl-icon--chromecast-connecting-C">
                <use xlinkHref="#icon_chromecast_p5" />
            </svg>
        </Button>
    );
}

ChromecastButton.propTypes = propTypes;
