import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';

const propTypes = {
    hasAltShortcut: PropTypes.bool.isRequired,
    onClip: PropTypes.func.isRequired,
};

export function ClipsButton({ hasAltShortcut, onClip }) {
    const label = hasAltShortcut ? 'Clip (Alt+X)' : 'Clip';
    return (
        <Button
            className={'player-button pl-clips-button'}
            onClick={onClip}
        >
            <Icon
                label={label}
                iconId={'#icon_clips'}
            />
        </Button>
    );
}

ClipsButton.propTypes = propTypes;
