import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    close: PropTypes.func.isRequired,
};

export function ClosePopupButton({
    close,
}) {
    return (
        <button
            className="close-popup-button__button"
            data-test-close-popup-button-close={true}
            onClick={close}
        >
            <figure
                className="close-popup-button__close-icon"
            >
                <svg width="16px" height="16px" version="1.1" viewBox="0 0 16 16" x="0px" y="0px">
                    <path
                        d={`
                            M8 6.586L3.757 2.343 2.343 3.757 6.586
                            8l-4.243 4.243 1.414 1.414L8 9.414l4.243 4.243
                            1.414-1.414L9.414
                            8l4.243-4.243-1.414-1.414
                        `}
                    />
                </svg>
            </figure>
        </button>
    );
}

ClosePopupButton.propTypes = propTypes;
