import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';
import classNames from 'classnames';

const propTypes = {
    captionsEnabled: PropTypes.bool.isRequired,
    onDisableCaptions: PropTypes.func.isRequired,
    onEnableCaptions: PropTypes.func.isRequired,
};

const CC_BUTTON_CLASSES = classNames({
    'player-button': true,
});

export function ClosedCaptionButton({
    captionsEnabled,
    onDisableCaptions,
    onEnableCaptions,
}) {
    return captionsEnabled ? (
        <Button
            className={CC_BUTTON_CLASSES}
            onClick={onDisableCaptions}
            tabIndex="-1"
        >
            <Icon
                label={'Captions'}
                iconId={'#icon_cc_on'}
            />
        </Button>
    ) : (
        <Button
            className={CC_BUTTON_CLASSES}
            onClick={onEnableCaptions}
            tabIndex="-1"
        >
            <Icon
                label={'Captions'}
                iconId={'#icon_cc_off'}
            />
        </Button>
    );
}

ClosedCaptionButton.propTypes = propTypes;
