import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';
import classNames from 'classnames';

const propTypes = {
    canFullScreen: PropTypes.bool.isRequired,
    hasBranding: PropTypes.bool.isRequired,
    isFullScreen: PropTypes.bool.isRequired,
    onFullScreen: PropTypes.func.isRequired,
    onUnFullScreen: PropTypes.func.isRequired,
};

export function FullScreenButton({
    canFullScreen,
    hasBranding,
    isFullScreen,
    onFullScreen,
    onUnFullScreen,
}) {
    const classes = classNames({
        'player-button': true,
        'qa-fullscreen-button': true,
        'pl-button__fullscreen--cannot-fullscreen': !canFullScreen,
        'pl-mg-r-1': !hasBranding,
        'pl-button__fullscreen--tooltip-left': !hasBranding,
    });

    return isFullScreen ? (
        <Button
            className={classes}
            onClick={onUnFullScreen}
            disabled={!canFullScreen}
            tabIndex="-1"
        >
            <Icon
                label={'Exit Fullscreen'}
                iconId={'#icon_unfullscreen'}
            />
        </Button>
    ) : (
        <Button
            className={classes}
            onClick={onFullScreen}
            disabled={!canFullScreen}
            tabIndex="-1"
        >
            <Icon
                label={'Fullscreen'}
                iconId={'#icon_fullscreen'}
            />
        </Button>
    );
}

FullScreenButton.propTypes = propTypes;
