import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { translate } from 'react-i18next';
import classNames from 'classnames';

const propTypes = {
    notificationsEnabled: PropTypes.bool.isRequired,
    enable: PropTypes.func.isRequired,
    disable: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
    className: PropTypes.string,
};

export function NotificationsButtonComponent({ className, notificationsEnabled, enable, disable, t }) {
    const ACTIVE_BUTTON_CLASS = classNames(
        'pl-button',
        'pl-button--icon',
        'pl-button--status',
        className
    );

    const DEFAULT_BUTTON_CLASS = classNames(
        'pl-button',
        className
    );

    const activeNotificationsButton = (
        <Button
            className={ACTIVE_BUTTON_CLASS}
            onClick={disable}
        >
            <span>
                <figure>
                    <svg>
                        <use xlinkHref="#icon_pl-followcheck" />
                    </svg>
                </figure>
                {t('Notifications')}
            </span>
        </Button>
    );

    const defaultNotificationsButton = (
        <Button
            className={DEFAULT_BUTTON_CLASS}
            onClick={enable}
        >
            <span>
                {t('Turn On Notifications')}
            </span>
        </Button>
    );

    return notificationsEnabled ? activeNotificationsButton : defaultNotificationsButton;
}

NotificationsButtonComponent.propTypes = propTypes;
export const NotificationsButton = translate()(NotificationsButtonComponent);
