import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';
import { ReplaySVG } from 'ui/player-types/clips/common/svg/replay';
import classNames from 'classnames';

const propTypes = {
    paused: PropTypes.bool.isRequired,
    showReplay: PropTypes.bool.isRequired,
    onPlay: PropTypes.func.isRequired,
    onPause: PropTypes.func.isRequired,
};

const BUTTON_CLASSES = classNames({
    'player-button': true,
    'qa-pause-play-button': true,
});

export class PausePlayButton extends Component {
    render() {
        const { paused, onPlay, onPause } = this.props;

        const onClickHandler = paused ? onPlay : onPause;

        return (
            <Button
                className={BUTTON_CLASSES}
                onClick={onClickHandler}
                tabIndex="-1"
            >
                {this.getIcon()}
            </Button>
        );
    }

    getIcon() {
        const { paused, showReplay } = this.props;

        if (showReplay) {
            return (
                <span className={'player-tip--aleft'}>
                    <ReplaySVG />
                </span>
            );
        }

        if (paused) {
            return (
                <Icon
                    label={'Play'}
                    iconId={'#icon_play'}
                    labelClass={'player-tip--aleft'}
                />
            );
        }

        return (
            <Icon
                label={'Pause'}
                iconId={'#icon_pause'}
                labelClass={'player-tip--aleft'}
            />
        );
    }
}

PausePlayButton.propTypes = propTypes;

