import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import classNames from 'classnames';

const propTypes = {
    onClick: PropTypes.func.isRequired,
    className: PropTypes.string,
};

export const RecCloseButton = ({
    onClick,
    className,
}) => {
    const BUTTON_CLASSES = classNames('pl-close-button', className);

    return (
        <Button
            className={BUTTON_CLASSES}
            onClick={onClick}
        >
            <figure>
                <svg className="pl-close-button__svg">
                    <use xlinkHref="#pl-icon_close" />
                </svg>
            </figure>
        </Button>
    );
};

RecCloseButton.propTypes = propTypes;
