import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';
import classNames from 'classnames';

const propTypes = {
    theatreModeEnabled: PropTypes.bool.isRequired,
    turnOn: PropTypes.func.isRequired,
    turnOff: PropTypes.func.isRequired,
};

const CLASSES = classNames({
    'player-button': true,
    'qa-theatre-mode-button': true,
});

export function TheatreModeButton({ theatreModeEnabled, turnOn, turnOff }) {
    return theatreModeEnabled ? (
        <Button
            className={CLASSES}
            onClick={turnOff}
            tabIndex="-1"
        >
            <Icon
                label={'Exit Theatre Mode'}
                iconId={'#icon_theatre_deactivate'}
            />
        </Button>
    ) : (
        <Button
            className={CLASSES}
            onClick={turnOn}
            tabIndex="-1"
        >
            <Icon
                label={'Theatre Mode'}
                iconId={'#icon_theatre'}
            />
        </Button>
    );
}

TheatreModeButton.propTypes = propTypes;
