import React from 'react';
import PropTypes from 'prop-types';
import { Button } from './base-button';
import { Icon } from './base-icon';
import classNames from 'classnames';

const propTypes = {
    onClick: PropTypes.func.isRequired,
    buttonLabel: PropTypes.string.isRequired,
};

const defaultProps = {
    onClick: () => {},
    buttonLabel: '',
};

const BUTTON_CLASSES = classNames(
    'player-button',
    'player-button--twitch',
    'qa-watch-twitch-button'
);

export const WatchTwitchButton = ({ onClick, buttonLabel }) => {
    return (
        <Button
            className={BUTTON_CLASSES}
            onClick={onClick}
        >
            <Icon
                label={buttonLabel}
                iconId={'#icon_twitch'}
                labelClass={'player-tip--aright'}
            />
        </Button>
    );
};

WatchTwitchButton.propTypes = propTypes;
WatchTwitchButton.defaultProps = defaultProps;
