import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { SelectDropdown } from '../common/select-dropdown';

const propTypes = {
    currentAlignment: PropTypes.string.isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const LEFT = Object.freeze({
    value: 'left',
    text: 'Left',
});

const CENTER = Object.freeze({
    value: 'center',
    text: 'Center',
});

const RIGHT = Object.freeze({
    value: 'right',
    text: 'Right',
});

const ALIGNMENT_OPTIONS = Object.freeze([
    LEFT,
    CENTER,
    RIGHT,
]);

export function AlignmentDropdownComponent({
    currentAlignment,
    onSelect,
    t,
}) {
    return (
        <div className="cc-customize-field">
            <label htmlFor="ccAlignment">{t('Alignment')}</label>
            <SelectDropdown
                id="ccAlignment"
                currentValue={currentAlignment}
                onSelect={onSelect}
                options={ALIGNMENT_OPTIONS}
            />
        </div>
    );
}

AlignmentDropdownComponent.propTypes = propTypes;
export const AlignmentDropdown = translate()(AlignmentDropdownComponent);
