import React from 'react';
import PropTypes from 'prop-types';
import { ColorPalette } from './color-palette';
import { OpacityDropdown } from './opacity-dropdown';

const propTypes = {
    currentColor: PropTypes.string.isRequired,
    currentOpacity: PropTypes.string.isRequired,
    selectColor: PropTypes.func.isRequired,
    selectOpacity: PropTypes.func.isRequired,
};

const COLORS = Object.freeze([
    'transparent',
    'white',
    'lightgray',
    'gray',
    'darkgray',
    'black',
    'green',
    'blue',
    'cyan',
    'magenta',
    'yellow',
    'red',
]);

export function BGandWindowPanel({
    currentColor,
    selectColor,
    selectOpacity,
    currentOpacity,
}) {
    return (
        <div className="cc-panel-menu-frame">
            <OpacityDropdown
                currentOpacity={currentOpacity}
                onSelect={selectOpacity}
            />
            <ColorPalette
                currentColor={currentColor}
                onSelect={selectColor}
                colors={COLORS}
            />
        </div>
    );
}

BGandWindowPanel.propTypes = propTypes;
