import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { translate } from 'react-i18next';
import { PRESETS } from 'ui/containers/closed-captions/presets-panel';
import { TEXT } from 'ui/containers/closed-captions/text-panel';
import { EFFECTS } from 'ui/containers/closed-captions/effects-panel';
import { BACKGROUND } from 'ui/containers/closed-captions/background-panel';
import { WINDOW } from 'ui/containers/closed-captions/window-panel';

const TABS = [
    PRESETS,
    TEXT,
    EFFECTS,
    BACKGROUND,
    WINDOW,
];

const propTypes = {
    currentPanel: PropTypes.string.isRequired,
    selectPanel: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    t() {},
};

function makeKeyUpFn(callback) {
    return function onKeyUp({ key }) {
        if (key === 'Enter') {
            callback();
        }
    };
}

export function CCPanelTabsComponent({ currentPanel, selectPanel, t }) {
    const tabs = TABS.map((tabName, index) => {
        function onClick() {
            selectPanel(tabName);
        }
        const listClasses = classNames({
            'player-tabs__item': true,
            'player-tabs__item--active': currentPanel === tabName,
        });
        /* Reasons for disabling lint rules:
         * jsx-a11y/anchor-is-valid: Disabled as this was around before the rule was added.
         */
        return (
            <li
                key={`${tabName}__${index}`}
                className={listClasses}
            >
                <a // eslint-disable-line jsx-a11y/anchor-is-valid
                    onClick={onClick}
                    onKeyUp={makeKeyUpFn(onClick)}
                    role="button"
                    tabIndex={0}
                >
                    {t(tabName)}
                </a>
            </li>
        );
    });

    return (
        <ul className="player-tabs clearfix">
            {tabs}
        </ul>
    );
}

CCPanelTabsComponent.propTypes = propTypes;
CCPanelTabsComponent.defaultProps = defaultProps;

export const CCPanelTabs = translate()(CCPanelTabsComponent);
