import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { Button } from '../buttons/base-button';
import { CCPanelTabs } from './closed-captions-panel-tabs';
import { PresetsPanel, PRESETS } from '../../containers/closed-captions/presets-panel';
import { TextPanel, TEXT } from '../../containers/closed-captions/text-panel';
import { EffectsPanel, EFFECTS } from '../../containers/closed-captions/effects-panel';
import { BackgroundPanel, BACKGROUND } from '../../containers/closed-captions/background-panel';
import { WindowPanel, WINDOW } from '../../containers/closed-captions/window-panel';
import classNames from 'classnames';

const propTypes = {
    onClose: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    t() {},
};

export class ClosedCaptionsPanelComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.selectPanel = this.selectPanel.bind(this);
        this.state = {
            currentPanel: PRESETS,
        };
    }

    selectPanel(modal) {
        this.setState({
            currentPanel: modal,
        });
    }

    // eslint-disable-next-line complexity
    getPanelComponent() {
        const { currentPanel } = this.state;

        switch (currentPanel) {
        case PRESETS:
            return <PresetsPanel />;
        case EFFECTS:
            return <EffectsPanel />;
        case BACKGROUND:
            return <BackgroundPanel />;
        case WINDOW:
            return <WindowPanel />;
        case TEXT:
            return <TextPanel />;
        default:
            return <PresetsPanel />;
        }
    }

    render() {
        const { onClose, t } = this.props;
        const { currentPanel } = this.state;

        const contentClasses = classNames({
            'pl-modal__content': true,
            'pl-modal__content--text': currentPanel === TEXT,
        });

        return (
            <div className={contentClasses}>
                <Button
                    className="pl-modal__close"
                    onClick={onClose}
                >
                    <svg>
                        <use xlinkHref="#icon_close_modal" />
                    </svg>
                </Button>
                <h2 className="pl-modal__header">
                    {t('Closed Caption Settings')}
                </h2>
                <CCPanelTabs
                    selectPanel={this.selectPanel}
                    currentPanel={currentPanel}
                />
                {this.getPanelComponent(currentPanel)}
            </div>
        );
    }
}

ClosedCaptionsPanelComponent.propTypes = propTypes;
ClosedCaptionsPanelComponent.defaultProps = defaultProps;

export const ClosedCaptionsPanel = translate()(ClosedCaptionsPanelComponent);
