import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import classNames from 'classnames';

const propTypes = {
    currentColor: PropTypes.string.isRequired,
    colors: PropTypes.array.isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

export function ColorPaletteComponent({ onSelect, currentColor, colors, t }) {
    const colorPalette = colors.map(color => {
        function onClick() {
            onSelect(color);
        }
        function onKeyUp({ key }) {
            if (key === 'Enter') {
                onClick();
            }
        }

        const noColorLine = color === 'transparent' ?
            <hr className="cc-no-color" /> :
            null;

        const LABEL_CLASSES = classNames({
            'cc-color-palette__square': true,
            [`cc-color-palette__square-${color}`]: true,
            'cc-color-palette__square-selected': color === currentColor,
        });

        return (
            <div
                className="cc-color-palette__container"
                key={`color-palette.${color}`}
            >
                {noColorLine}
                <div
                    role="button"
                    className={LABEL_CLASSES}
                    onClick={onClick}
                    onKeyUp={onKeyUp}
                    tabIndex={-1}
                />
            </div>
        );
    });

    return (
        <div className="cc-customize-field">
            <label htmlFor="colorPalette">{t('Color')}</label>
            <div id="colorPalette" className="cc-color-palette">
                {colorPalette}
            </div>
        </div>
    );
}

ColorPaletteComponent.propTypes = propTypes;

export const ColorPalette = translate()(ColorPaletteComponent);
