import React from 'react';
import PropTypes from 'prop-types';
import { TextStylePalette } from './text-style-palette';
import { TextEffectsPalette } from './text-effects-palette';

const propTypes = {
    boldText: PropTypes.bool.isRequired,
    italicText: PropTypes.bool.isRequired,
    underlineText: PropTypes.bool.isRequired,
    currentTextEffect: PropTypes.string.isRequired,
    selectTextEffect: PropTypes.func.isRequired,
    selectTextStyle: PropTypes.func.isRequired,
};

export function EffectsPanel({
    boldText,
    italicText,
    underlineText,
    selectTextEffect,
    selectTextStyle,
    currentTextEffect,
}) {
    return (
        <div className="cc-panel-menu-frame">
            <TextStylePalette
                boldText={boldText}
                italicText={italicText}
                underlineText={underlineText}
                selectTextStyle={selectTextStyle}
            />
            <TextEffectsPalette
                currentTextEffect={currentTextEffect}
                selectTextEffect={selectTextEffect}
            />
        </div>
    );
}

EffectsPanel.propTypes = propTypes;
