import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { SelectDropdown } from '../common/select-dropdown';

const propTypes = {
    currentFont: PropTypes.string.isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const MONO_SERIF = Object.freeze({
    value: 'mono-serif',
    text: 'Mono Serif',
});

const PROP_SERIF = Object.freeze({
    value: 'prop-serif',
    text: 'Serif',
});

const MONO_SANS_SERIF = Object.freeze({
    value: 'mono-sans-serif',
    text: 'Mono Sans-Serif',
});

const SANS_SERIF = Object.freeze({
    value: 'prop-sans-serif',
    text: 'Sans-Serif',
});

const CASUAL = Object.freeze({
    value: 'casual',
    text: 'Casual',
});

const CURSIVE = Object.freeze({
    value: 'cursive',
    text: 'Cursive',
});

const SMALL_CAPTIALS = Object.freeze({
    value: 'small-capitals',
    text: 'Small Capitals',
});

const FONT_OPTIONS = Object.freeze([
    MONO_SERIF,
    PROP_SERIF,
    MONO_SANS_SERIF,
    SANS_SERIF,
    CASUAL,
    CURSIVE,
    SMALL_CAPTIALS,
]);

export function FontDropdownComponent({
    t,
    currentFont,
    onSelect,
}) {
    return (
        <div className="cc-customize-field">
            <label htmlFor="fontLabel">{t('Font')}</label>
            <SelectDropdown
                currentValue={currentFont}
                id="fontLabel"
                onSelect={onSelect}
                options={FONT_OPTIONS}
            />
        </div>
    );
}

FontDropdownComponent.propTypes = propTypes;
export const FontDropdown = translate()(FontDropdownComponent);
