import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { SelectDropdown } from '../common/select-dropdown';

const propTypes = {
    currentOpacity: PropTypes.string.isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const SOLID = Object.freeze({
    value: 'solid',
    text: 'Solid',
});

const TRANSLUCENT = Object.freeze({
    value: 'translucent',
    text: 'Translucent',
});

const SEMI_TRANSPARENT = Object.freeze({
    value: 'semiTransparent',
    text: 'Semi-Transparent',
});

const FLASHING = Object.freeze({
    value: 'flashing',
    text: 'Flashing',
});

const FONT_OPACITY_OPTIONS = Object.freeze([
    SOLID,
    TRANSLUCENT,
    SEMI_TRANSPARENT,
    FLASHING,
]);

export function FontOpacityDropdownComponent({
    currentOpacity,
    onSelect,
    t,
}) {
    return (
        <div className="cc-customize-field">
            <label htmlFor="fontOpacity">{t('Opacity')}</label>
            <SelectDropdown
                currentValue={currentOpacity}
                id="fontOpacity"
                onSelect={onSelect}
                options={FONT_OPACITY_OPTIONS}
            />
        </div>
    );
}

FontOpacityDropdownComponent.propTypes = propTypes;
export const FontOpacityDropdown = translate()(FontOpacityDropdownComponent);
