import React from 'react';
import PropTypes from 'prop-types';
import { SelectDropdown } from 'ui/components/common/select-dropdown';
import { translate } from 'react-i18next';

const propTypes = {
    currentOpacity: PropTypes.string.isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};
const SOLID_OPTION = Object.freeze({
    text: 'Solid',
    value: 'solid',
});

const TRANSLUCENT_OPTION = Object.freeze({
    text: 'Translucent',
    value: 'translucent',
});

const OPACITY_OPTIONS = Object.freeze([
    SOLID_OPTION,
    TRANSLUCENT_OPTION,
]);

export function OpacityDropdownComponent({ onSelect, currentOpacity, t }) {
    return (
        <div className="cc-customize-field">
            <label htmlFor="bgOpacity">{t('Opacity')}</label>
            <SelectDropdown
                currentValue={currentOpacity}
                id="bgOpacity"
                onSelect={onSelect}
                options={OPACITY_OPTIONS}
            />
        </div>
    );
}

OpacityDropdownComponent.propTypes = propTypes;

export const OpacityDropdown = translate()(OpacityDropdownComponent);
