import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { SelectDropdown } from '../common/select-dropdown';

const propTypes = {
    currentPosition: PropTypes.string.isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const BOTTOM = Object.freeze({
    value: 'bottom',
    text: 'Bottom',
});

const TOP = Object.freeze({
    value: 'top',
    text: 'Top',
});

const POSITION_OPTIONS = Object.freeze([
    BOTTOM,
    TOP,
]);

export function PositionDropdownComponent({
    currentPosition,
    onSelect,
    t,
}) {
    return (
        <div className="cc-customize-field">
            <label htmlFor="verticalPosition">{t('Position')}</label>
            <SelectDropdown
                currentValue={currentPosition}
                id="verticalPosition"
                onSelect={onSelect}
                options={POSITION_OPTIONS}
            />
        </div>
    );
}

PositionDropdownComponent.propTypes = propTypes;
export const PositionDropdown = translate()(PositionDropdownComponent);
