import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { Button } from '../buttons/base-button';

const propTypes = {
    increaseSize: PropTypes.func.isRequired,
    decreaseSize: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

export function SizePaletteComponent({
    increaseSize,
    decreaseSize,
    t,
}) {
    return (
        <div className="cc-customize-field">
            <label htmlFor="sizePalette">{t('Size')}</label>
            <Button
                className="cc-font-size cc-font-size--increment"
                id="sizePalette"
                onClick={increaseSize}
            >
                A
                <span
                    className="player-tip"
                    data-tip={t('Increase Size')}
                />
            </Button>
            <Button
                className="cc-font-size cc-font-size--decrement"
                id="sizePalette"
                onClick={decreaseSize}
            >
                A
                <span
                    className="player-tip"
                    data-tip={t('Decrease Size')}
                />
            </Button>
        </div>
    );
}

SizePaletteComponent.propTypes = propTypes;
export const SizePalette = translate()(SizePaletteComponent);
