import React from 'react';
import PropTypes from 'prop-types';
import { FontDropdown } from './font-dropdown';
import { AlignmentDropdown } from './alignment-dropdown';
import { PositionDropdown } from './position-dropdown';
import { FontOpacityDropdown } from './font-opacity-dropdown';
import { ColorPalette } from './color-palette';
import { SizePalette } from './size-palette';
import { fontSizeMap } from 'captions/captions-style-map';

const propTypes = {
    currentAlignment: PropTypes.string.isRequired,
    currentColor: PropTypes.string.isRequired,
    currentFont: PropTypes.string.isRequired,
    currentFontSize: PropTypes.number.isRequired,
    currentPosition: PropTypes.string.isRequired,
    currentOpacity: PropTypes.string.isRequired,
    selectFontChange: PropTypes.func.isRequired,
};

const COLORS = Object.freeze([
    'white',
    'black',
    'red',
    'green',
    'cyan',
    'magenta',
    'yellow',
    'blue',
]);

const FONT = 'font';
const FONT_COLOR_NAME = 'fontColorName';
const ALIGNMENT = 'alignment';
const VERTICAL_POSITION = 'verticalPosition';
const FONT_OPACITY = 'fontOpacity';
const FONT_SIZE = 'fontSize';

export function TextPanel({
    currentAlignment,
    currentColor,
    currentFont,
    currentFontSize,
    currentPosition,
    currentOpacity,
    selectFontChange,
}) {
    function selectVerticalPositon(position) {
        selectFontChange(VERTICAL_POSITION, position);
    }
    function selectFontColor(fontColorName) {
        selectFontChange(FONT_COLOR_NAME, fontColorName);
    }
    function selectFont(font) {
        selectFontChange(FONT, font);
    }
    function selectAlignment(alignment) {
        selectFontChange(ALIGNMENT, alignment);
    }
    function selectFontOpacity(opacity) {
        selectFontChange(FONT_OPACITY, opacity);
    }
    function increaseSize() {
        if (currentFontSize < fontSizeMap.max) {
            selectFontChange(
                FONT_SIZE,
                currentFontSize + fontSizeMap.increment
            );
        }
    }
    function decreaseSize() {
        if (currentFontSize > fontSizeMap.min) {
            selectFontChange(
                FONT_SIZE,
                currentFontSize + fontSizeMap.decrement
            );
        }
    }
    return (
        <div className="cc-panel-menu-frame">
            <FontDropdown
                currentFont={currentFont}
                onSelect={selectFont}
            />
            <AlignmentDropdown
                currentAlignment={currentAlignment}
                onSelect={selectAlignment}
            />
            <ColorPalette
                currentColor={currentColor}
                onSelect={selectFontColor}
                colors={COLORS}
            />
            <PositionDropdown
                currentPosition={currentPosition}
                onSelect={selectVerticalPositon}
            />
            <FontOpacityDropdown
                currentOpacity={currentOpacity}
                onSelect={selectFontOpacity}
            />
            <SizePalette
                increaseSize={increaseSize}
                decreaseSize={decreaseSize}
            />
        </div>
    );
}

TextPanel.propTypes = propTypes;
