import PropTypes from 'prop-types';
import React from 'react';
import { translate } from 'react-i18next';
import classNames from 'classnames';

const propTypes = {
    t: PropTypes.func.isRequired,
};

const CLASSES_OVERLAY = classNames(
    'player-overlay',
    'player-overlay--wall',
    'player-overlay--empty-collection'
);

export function CollectionEmptyOverlayComponent({ t }) {
    return (
        <div className={CLASSES_OVERLAY}>
            <div className="player-center-content">
                <p>{t('This collection is empty.')}</p>
            </div>
        </div>
    );
}

CollectionEmptyOverlayComponent.propTypes = propTypes;

export const CollectionEmptyOverlay = translate()(CollectionEmptyOverlayComponent);
