import PropTypes from 'prop-types';
import React from 'react';
import { Button } from 'ui/components/buttons/base-button';
import classNames from 'classnames';
import { toHumanReadable } from 'util/duration-utils';
import { translate, Interpolate } from 'react-i18next';

/* eslint-disable camelcase */
const propTypes = {
    title: PropTypes.string.isRequired,
    ownerURL: PropTypes.string.isRequired,
    ownerName: PropTypes.string.isRequired,
    itemsLength: PropTypes.number.isRequired,
    totalDuration: PropTypes.number.isRequired, // seconds
    onClose: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const CLASSES_SIDEBAR_HEADER_TITLE = classNames(
    'collection-sidebar-header__title',
    'ellipsis',
    'qa-collection-header-title'
);

export const CollectionSidebarHeaderComponent = ({
    title,
    ownerURL,
    ownerName,
    itemsLength,
    totalDuration,
    onClose,
    t,
}) => {
    const closeButton = (
        <Button
            className="player-button"
            onClick={onClose}
        >
            <svg><use xlinkHref="#icon_close_md" /></svg>
        </Button>
    );

    const authorURLElement = (
        <a
            className="qa-collection-sidebar-author"
            href={ownerURL}
        >
            {ownerName}
        </a>
    );

    let timeText = null;
    const { minutes, hours } = toHumanReadable(totalDuration * 1000);
    const minutesText = t('{{count}} minute', { count: minutes });
    const hoursText = t('{{count}} hour', { count: hours });

    if (hours === 0) {
        timeText = minutesText;
    } else if (minutes === 0) {
        timeText = hoursText;
    } else {
        timeText = t('{{hoursText}} and {{minutesText}}', {
            hoursText,
            minutesText,
        });
    }

    return (
        <div className="collection-sidebar-header">
            <div className="collection-sidebar-header__layout">
                <div className={CLASSES_SIDEBAR_HEADER_TITLE}>{title}</div>
                <div className="collection-sidebar-header-meta">
                    <span>
                        <Interpolate
                            i18nKey={'By {{author}}'}
                            author={authorURLElement}
                        />
                    </span>
                    <span className="middot-divider" />
                    <span>{t('{{count}} video', { count: itemsLength })}</span>
                    <span className="middot-divider" />
                    <span>{timeText}</span>
                </div>
            </div>
            {closeButton}
        </div>
    );
};

CollectionSidebarHeaderComponent.propTypes = propTypes;
export const CollectionSidebarHeader = translate()(CollectionSidebarHeaderComponent);
