import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';

const propTypes = {
    index: PropTypes.number.isRequired,
    onSelect: PropTypes.func.isRequired,
    selectItem: PropTypes.any.isRequired,
    isActive: PropTypes.bool,
    thumbnailURL: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    subTitle: PropTypes.string,
};

const defaultProps = {
    isActive: false,
    subTitle: '',
};

const CLASSES_ITEM_NUMBER = classNames(
    'collection-sidebar-item__number',
    'pl-flex__item',
    'qa-collection-item-number'
);

const CLASSES_ITEM_THUMBNAIL = classNames(
    'collection-sidebar-item__thumbnail',
    'pl-flex__item',
    'qa-collection-item-thumbnail'
);

const CLASSES_ITEM_DETAIL = classNames(
    'collection-sidebar-item-detail',
    'pl-flex__item'
);

const CLASSES_ITEM_TITLE = classNames(
    'collection-sidebar-item-detail__title',
    'qa-collection-item-title'
);

export class CollectionSidebarItem extends React.Component {
    constructor() {
        super(...arguments);

        this.handleClick = this.handleClick.bind(this);
        this.handleKeyUp = this.handleKeyUp.bind(this);
    }

    render() {
        const {
            isActive,
            thumbnailURL,
            title,
            subTitle,
            index,
        } = this.props;

        const CLASSES_SIDEBAR_ITEM = classNames({
            'collection-sidebar-item': true,
            'collection-sidebar-item--active': isActive,
            'pl-flex': true,
            'pl-flex--verticalCenter': true,
            'pl-flex--nowrap': true,
        });

        return (
            /* Reasons for disabling lint rules:
             * jsx-a11y/no-static-element-interactions: the div must be clickable to be able
             * to select the sidebar item. This is kept as a div because the there's a bit of
             * of markup and additional information needed in the div.
             */
            // eslint-disable-next-line jsx-a11y/no-static-element-interactions
            <div
                className={CLASSES_SIDEBAR_ITEM}
                onClick={this.handleClick}
                onKeyUp={this.handleKeyUp}
                tabIndex={0}
                role="button"
            >
                <div className={CLASSES_ITEM_NUMBER}>{index + 1}</div>
                <img
                    className={CLASSES_ITEM_THUMBNAIL}
                    alt="Thumbnail of one of the videos in the collection."
                    src={thumbnailURL}
                />
                <div className={CLASSES_ITEM_DETAIL}>
                    <div className={CLASSES_ITEM_TITLE}>{title}</div>
                    <div className="collection-sidebar-item-detail__meta">
                        <span className="qa-collection-item-channel">{subTitle}</span>
                    </div>
                </div>
            </div>
        );
    }

    handleKeyUp(event) {
        if (event.key === 'Enter') {
            this.props.onSelect(this.props.selectItem);
        }
    }

    handleClick() {
        this.props.onSelect(this.props.selectItem);
    }
}

CollectionSidebarItem.propTypes = propTypes;
CollectionSidebarItem.defaultProps = defaultProps;
