import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

const DEFAULT_THUMBNAIL_URL = 'https://static-cdn.jtvnw.net/ttv-playlists-thumbnails-prod/no-thumbnail-sm.png';

/* eslint-disable camelcase */
const propTypes = {
    currentVideoId: PropTypes.string.isRequired,
    collectionItems: PropTypes.arrayOf(PropTypes.shape({
        item_id: PropTypes.string,
        title: PropTypes.string,
        thumbnails: PropTypes.object,
        owner: PropTypes.shape({
            display_name: PropTypes.string,
        }),
    })).isRequired,
};

const CLASSES_SIDEBAR_ITEM = classNames(
    'collection-sidebar-item',
    'pl-flex',
    'pl-flex--verticalCenter',
    'pl-flex--nowrap'
);

const CLASSES_ITEM_NUMBER = classNames(
    'collection-sidebar-item__number',
    'pl-flex__item',
    'qa-collection-item-number'
);

const CLASSES_ITEM_THUMBNAIL = classNames(
    'collection-sidebar-item__thumbnail',
    'pl-flex__item',
    'qa-collection-item-thumbnail'
);

const CLASSES_ITEM_DETAIL = classNames(
    'collection-sidebar-item-detail',
    'pl-flex__item'
);

const CLASSES_ITEM_FLAG_SUB = classNames(
    'collection-sidebar-item__flag',
    'collection-sidebar-item__flag__sub'
);

const CLASSES_ITEM_FLAG_MATURE = classNames(
    'collection-sidebar-item__flag',
    'collection-sidebar-item__flag__mature'
);

const CLASSES_ITEM_FLAG_21 = classNames(
    'collection-sidebar-item__flag',
    'collection-sidebar-item__flag__21'
);

const CLASSES_ITEM_TITLE = classNames(
    'collection-sidebar-item-detail__title',
    'qa-collection-item-title'
);

export const CollectionSidebarItems = ({ collectionItems, currentVideoId }) => {
    const collectionItemElements = collectionItems.map((item, index) => {
        const thumbnailSrc = item.thumbnails ? item.thumbnails.small : DEFAULT_THUMBNAIL_URL;
        const isCurrentItem = currentVideoId === `v${item.itemId}`;

        return (
            <div
                className={CLASSES_SIDEBAR_ITEM}
                data-currentvod={isCurrentItem}
                data-vod-id={item.itemId}
                key={item.itemId}
            >
                <div className={CLASSES_ITEM_NUMBER}>{index + 1}</div>
                <img
                    className={CLASSES_ITEM_THUMBNAIL}
                    alt="Thumbnail of one of the videos in the collection." src={thumbnailSrc}
                />
                <div className={CLASSES_ITEM_DETAIL}>
                    <div className={CLASSES_ITEM_TITLE}>{item.title}</div>
                    <div className="collection-sidebar-item-detail__meta">
                        <span className="qa-collection-item-channel">{item.owner.displayName}</span>
                        <span
                            className={CLASSES_ITEM_FLAG_SUB}
                            data-sub="false"
                        >
                            Subscriber-only
                        </span>
                        <span
                            className={CLASSES_ITEM_FLAG_MATURE}
                            data-mature="false"
                        >
                            Mature
                        </span>
                        <span
                            className={CLASSES_ITEM_FLAG_21}
                            data-age-gate="false"
                        >
                            21+
                        </span>
                    </div>
                </div>
            </div>
        );
        /* eslint-enable camelcase */
    });

    return (
        <div className="collection-sidebar-item-container">
            {collectionItemElements}
        </div>
    );
};

CollectionSidebarItems.propTypes = propTypes;
