import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import findIndex from 'lodash/findIndex';
import classNames from 'classnames';
import { Button } from 'ui/components/buttons/base-button';

const propTypes = {
    collectionItems: PropTypes.array.isRequired,
    showDivider: PropTypes.bool.isRequired,
    onMouseEnter: PropTypes.func,
    onMouseLeave: PropTypes.func,
    showSidebar: PropTypes.func,
    streamId: PropTypes.string.isRequired,
    t: PropTypes.func,
    title: PropTypes.string.isRequired,
};

const defaultProps = {
    showSidebar() {},
    t() {},
    onMouseEnter() {},
    onMouseLeave() {},
};

const CLASSES_FLEX_CENTER = classNames(
    'pl-flex',
    'pl-flex--verticalCenter',
    'pl-flex--nowrap'
);

const CLASSES_BUTTON_COLLECTION = classNames(
    'collection-button',
    'pl-flex__item'
);

const CLASSES_COLLECTION_COLLAPSED_INFO = classNames(
    'collection-collapsed-info',
    'pl-flex',
    'pl-flex--verticalCenter',
    'pl-flex__item'
);

const CLASSES_COLLECTION_TITLE = classNames(
    'collection-collapsed-info__title',
    'qa-collection-collapsed-title',
    'pl-flex__item'
);

const CLASSES_COLLECTION_DIVIDER = classNames(
    'middot-divider',
    'pl-flex__item'
);

const CLASSES_COLLECTION_PROGRESS = classNames(
    'collection-collapsed-info__number',
    'qa-collection-collapsed-progress',
    'pl-flex__item'
);

/* eslint-disable jsx-a11y/no-static-element-interactions */
export function CollectionTopBarComponent({
    collectionItems,
    showDivider,
    onMouseEnter,
    onMouseLeave,
    showSidebar,
    streamId,
    t,
    title,
}) {
    const collectionDivider = showDivider ? (
        <div className="collection-divider" />
    ) : null;

    const progressText = t('{{currentPosition}}/{{totalVideos}} videos', {
        currentPosition: findIndex(collectionItems, { itemId: streamId }) + 1,
        totalVideos: collectionItems.length,
    });

    return (
        <div className="collection-nav">
            <div
                className="collection-collapsed__layout"
                onMouseEnter={onMouseEnter}
                onMouseLeave={onMouseLeave}
                onClick={showSidebar}
                onKeyUp={showSidebar}
                tabIndex={0}
                role="button"
            >
                <div className={CLASSES_FLEX_CENTER}>
                    <Button
                        className={CLASSES_BUTTON_COLLECTION}
                        onClick={showSidebar}
                    >
                        <svg><use xlinkHref="#icon_open_collection" /></svg>
                    </Button>
                    <div className={CLASSES_COLLECTION_COLLAPSED_INFO}>
                        <div className={CLASSES_COLLECTION_TITLE}>{title}</div>
                        <span className={CLASSES_COLLECTION_DIVIDER} />
                        <span className={CLASSES_COLLECTION_PROGRESS}>{progressText}</span>
                    </div>
                </div>
            </div>
            {collectionDivider}
        </div>
    );
}
/* eslint-enable */

CollectionTopBarComponent.propTypes = propTypes;
CollectionTopBarComponent.defaultProps = defaultProps;

export const CollectionTopBar = translate()(CollectionTopBarComponent);
