import React from 'react';
import PropTypes from 'prop-types';
import { PlayerCard } from 'ui/components/recommendations/cards/player-card';

const propTypes = {
    featuredCollection: PropTypes.shape({
        id: PropTypes.string,
        title: PropTypes.string,
        itemsCount: PropTypes.number,
        owner: PropTypes.shape({
            displayName: PropTypes.string,
            id: PropTypes.string,
            name: PropTypes.string,
        }),
    }).isRequired,
    thumbnailURL: PropTypes.string.isRequired,
    onSelect: PropTypes.func,
};

const defaultProps = {
    onSelect() {},
};

export function FeaturedCollectionComponent({
    thumbnailURL,
    onSelect,
    featuredCollection,
}) {
    const featuredCollectionInfo = (
        <span>
            <figure className="pl-card__smallicon">
                <svg>
                    <use xlinkHref="#icon_open_collection" />
                </svg>
            </figure>
            <span>{featuredCollection.title}</span>
        </span>
    );

    return (
        <PlayerCard
            className="pl-rec__item"
            thumbnailURL={thumbnailURL}
            info={featuredCollectionInfo}
            onSelect={onSelect}
            selectItem={featuredCollection}
            hasThumbZoom={true}
            hasBorder={true}
        />
    );
}

FeaturedCollectionComponent.propTypes = propTypes;
FeaturedCollectionComponent.defaultProps = defaultProps;

