import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    alt: PropTypes.string,
    classNames: PropTypes.shape({
        a: PropTypes.string,
        img: PropTypes.string,
    }),
    href: PropTypes.string,
    imgSrc: PropTypes.string,
    onClick: PropTypes.func,
    target: PropTypes.string,
};

export const LinkedImage = ({
    alt,
    classNames,
    href,
    imgSrc,
    onClick,
    target,
}) => {
    return (
        <a
            className={classNames.a}
            href={href}
            target={target}
            onClick={onClick}
        >
            <img
                alt={alt}
                className={classNames.img}
                src={imgSrc}
            />
        </a>
    );
};

LinkedImage.propTypes = propTypes;
