import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';

const propTypes = {
    className: PropTypes.string,
    currentValue: PropTypes.string.isRequired,
    id: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
        value: PropTypes.string.isRequired,
        text: PropTypes.string.isRequired,
    })).isRequired,
    onSelect: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    className: '',
    id: '',
};

export function SelectDropdownComponent({
    className,
    currentValue,
    id,
    onSelect,
    options,
    t,
}) {
    function changeFn(event) {
        onSelect(event.target.value);
    }
    const opts = options.map(({ value, text }) => {
        return (
            <option
                key={`option.${value}.${text}`}
                value={value}
            >
                {t(text)}
            </option>
        );
    });

    return (
        <select
            className={className}
            onChange={changeFn}
            onBlur={changeFn}
            value={currentValue}
            id={id}
        >
            {opts}
        </select>
    );
}

SelectDropdownComponent.propTypes = propTypes;
SelectDropdownComponent.defaultProps = defaultProps;

export const SelectDropdown = translate()(SelectDropdownComponent);
