import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    fill: PropTypes.string,
};

const defaultProps = {
    fill: '#F9F7FC',
};

/* eslint-disable max-len */
export const AgeGateFailedSVG = props => {
    return (
        <SVGWrapper
            viewBox="0 0 92 81"
            {...props}
        >
            <path
                d="M0 75.6l3.067-5.4L9.2 59.4l12.267-21.6 12.266-21.6 6.134-10.8L42.933 0h6.134l3.066 5.4 6.134 10.8 12.266 21.6L82.8 59.4l6.133 10.8L92 75.6 89.06 81H3.44L0 75.6zM40 27h12v13l-3 19h-6l-3-19V27zm1 34h10v10H41V61z"
                fill={props.fill}
            />
        </SVGWrapper>
    );
};
/* eslint-enable max-len */

AgeGateFailedSVG.propTypes = propTypes;
AgeGateFailedSVG.defaultProps = defaultProps;
