import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    fill: PropTypes.string,
    viewBox: PropTypes.string,
};

/* eslint-disable max-len */
export const ClipsSVG = props => (
    <SVGWrapper
        viewBox="0 0 30 30"
        {...props}
    >
        <path
            d="M14.802 7.804l-3.83 1.026 2.928 2.321 3.83-1.026-2.928-2.321zm2.895-.776l3.981-1.067.777 2.898-1.83.49-2.928-2.321zM7.969 9.635l-1.745.467L7 13l3.898-1.044-2.929-2.321zM7 13h16v9H7v-9zm1.969 3h2.785l2.228-3h-2.785l-2.228 3zm7.018 0h2.785L21 13h-2.785l-2.228 3z"
            fill={props.fill}
        />
    </SVGWrapper>
);
/* eslint-enable max-len */

ClipsSVG.propTypes = propTypes;
