import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    enabled: PropTypes.bool.isRequired,
    viewBox: PropTypes.string,
};

export const FullscreenSVG  = props => {
    /* eslint-disable max-len */
    if (props.enabled) {
        return (
            <SVGWrapper
                viewBox="0 0 30 30"
                {...props}
            >
                <path
                    d="M15,15 L23.2,15 L20.8,17.4 L23.8,20.4 L20.4,23.8 L17.4,20.8 L15,23.2 L15,15 L15,15 Z M15,15 L6.8,15 L9.2,12.6 L6.2,9.6 L9.6,6.2 L12.6,9.2 L15,6.8 L15,15 L15,15 Z"
                />
            </SVGWrapper>
        );
    }

    return (
        <SVGWrapper
            viewBox="0 0 30 30"
            {...props}
        >
            <path
                d="M7,7 L15.2,7 L12.8,9.4 L15.8,12.4 L12.4,15.8 L9.4,12.8 L7,15.2 L7,7 Z M23,23 L14.8,23 L17.2,20.6 L14.2,17.6 L17.6,14.2 L20.6,17.2 L23,14.8 L23,23 Z"
            />
        </SVGWrapper>
    );
    /* eslint-enable max-len */
};

FullscreenSVG.propTypes = propTypes;
