import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    fill: PropTypes.string,
    viewBox: PropTypes.string,
};

export const PauseSVG = props => (
    <SVGWrapper
        viewBox="0 0 30 30"
        {...props}
    >
        <path
            d="M9,22h4V8H9V22z M17,8v14h4V8H17z"
            fill={props.fill}
        />
    </SVGWrapper>
);

PauseSVG.propTypes = propTypes;
