import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    viewBox: PropTypes.string,
    fill: PropTypes.string,
};

export const PlaySVG = props => (
    <SVGWrapper
        viewBox="0 0 30 30"
        {...props}
    >
        <path
            d="M10,7l12,8l-12,8V7z"
            fill={props.fill}
        />
    </SVGWrapper>
);

PlaySVG.propTypes = propTypes;
