import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    fill: PropTypes.string,
    viewBox: PropTypes.string,
};

/* eslint-disable max-len */
export const SettingsSVG = props => (
    <SVGWrapper
        viewBox="0 0 30 30"
        {...props}
    >
        <path
            d="M13.3589744,7 L16.6410256,7 L18.0769231,9.8 L21.3589744,9.8 L23,12.2 L21.3589744,15 L23,17.8 L21.3589744,20.2 L18.0769231,20.2 L16.6410256,23 L13.3589744,23 L11.9230769,20.2 L8.64102564,20.2 L7,17.8 L8.64102564,15 L7,12.2 L8.64102564,9.8 L11.9230769,9.8 L13.3589744,7 Z M15,17.8 C16.5860485,17.8 17.8717949,16.5463973 17.8717949,15 C17.8717949,13.4536027 16.5860485,12.2 15,12.2 C13.4139515,12.2 12.1282051,13.4536027 12.1282051,15 C12.1282051,16.5463973 13.4139515,17.8 15,17.8 Z"
            fill={props.fill}
        />
    </SVGWrapper>
);
/* eslint-enable max-len */

SettingsSVG.propTypes = propTypes;
