import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    className: PropTypes.string,
    id: PropTypes.string,
    width: PropTypes.number,
    height: PropTypes.number,
    viewBox: PropTypes.string,
    preserveAspectRatio: PropTypes.string,
    children: PropTypes.oneOfType([
        PropTypes.arrayOf(PropTypes.element),
        PropTypes.element,
        PropTypes.node,
    ]),
};

export const SVGWrapper = props => {
    return (
        <svg
            className={props.className}
            id={props.id}
            width={props.width}
            height={props.height}
            viewBox={props.viewBox}
            preserveAspectRatio={props.preserveAspectRatio}
            xmlns="http://www.w3.org/2000/svg"
        >
            {props.children}
        </svg>
    );
};

SVGWrapper.propTypes = propTypes;
