import React from 'react';
import PropTypes from 'prop-types';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    enabled: PropTypes.bool.isRequired,
    fill: PropTypes.string,
    viewBox: PropTypes.string,
};

export const TheatreSVG = props => {
    if (props.enabled) {
        return (
            <SVGWrapper
                viewBox="0 0 30 30"
                {...props}
            >
                <path
                    d="M6 9h11v12H6V9zm2 2h9v8H8v-8zm9-2h7v12h-7V9zm2 2h3v8h-3v-8z"
                    fill={props.fill}
                />
            </SVGWrapper>
        );
    }

    return (
        <SVGWrapper
            viewBox="0 0 30 30"
            {...props}
        >
            <path
                d="M6 21h11V9H6v12zM19 9v12h5V9h-5z"
                fill={props.fill}
            />
        </SVGWrapper>
    );
};

TheatreSVG.propTypes = propTypes;
