import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const propTypes = {
    muted: PropTypes.bool.isRequired,
    fill: PropTypes.string,
    viewBox: PropTypes.string,
};

export const VolumeSVG = props => {
    const volumeClassName = classNames({
        'player-icon-volumemute': props.muted,
        'player-icon-volumefull': !props.muted,
    });

    /* eslint-disable max-len */
    if (props.muted) {
        return (
            <SVGWrapper
                viewBox="0 0 30 30"
                className={volumeClassName}
                {...props}
            >
                <path
                    d="M23,18L23,18h-0.7L20,15.7L17.7,18H17l0,0v-0.7l2.3-2.3L17,12.7V12l0,0h0.7l2.3,2.3l2.3-2.3H23l0,0v0.7L20.7,15l2.3,2.3V18z M7,18v-6l3,0l5-4v14l-5-4L7,18z"
                    fill={props.fill}
                />
            </SVGWrapper>
        );
    }

    return (
        <SVGWrapper
            viewBox="0 0 30 30"
            className={volumeClassName}
            {...props}
        >
            <path
                d="M22,21.5v-13L23,8v14L22,21.5z M18,10.5l1-0.5v10l-1-0.5V10.5z M7,18v-6l3,0l5-4v14l-5-4L7,18z"
                fill={props.fill}
            />
        </SVGWrapper>
    );

    /* eslint-enable max-len */
};

VolumeSVG.propTypes = propTypes;
