import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { translate } from 'react-i18next';
import { Button } from 'ui/components/buttons/base-button';

const CLASSES_MODAL_INNER = classNames({
    'pl-menu__inner': true,
    'extension-modal__inner': true,
});

const CLASSES_MODAL_HEADER = classNames({
    'pl-menu__section': true,
    'extension-modal__header': true,
});

const CLASSES_MODAL_TITLE = classNames({
    'pl-menu__item': true,
    'extension-modal__title': true,
});

const CLASSES_LIST_SECTION = classNames({
    'pl-menu__section': true,
    'pl-menu__section--with-sep': true,
});

const CLASSES_CANCEL_BUTTON = classNames({
    'pl-button': true,
    'pl-button--hollow': true,
    'extension-modal__button': true,
});

const CLASSES_CLOSE_BUTTON = classNames({
    'pl-close-button': true,
    'extension-modal__close-button': true,
});

const propTypes = {
    t: PropTypes.func.isRequired,
    onClose: PropTypes.func.isRequired,
};

const NEEDS_AUTH_TEXT = 'You must be logged in to use this extension feature';

export const ExtensionFeatureNeedsAuthModalComponent = props => {
    return (
        <div className={CLASSES_MODAL_INNER}>
            <div className={CLASSES_MODAL_HEADER}>
                <div className="extension-modal__header-row">
                    <div className={CLASSES_MODAL_TITLE}>
                        <div className="extension-modal__title-info">
                            {props.t(NEEDS_AUTH_TEXT)}
                        </div>
                    </div>
                    <Button className={CLASSES_CLOSE_BUTTON} onClick={props.onClose}>
                        <svg className="pl-close-button__svg">
                            <use xlinkHref="#pl-icon_close" />
                        </svg>
                    </Button>
                </div>
            </div>
            <div className={CLASSES_LIST_SECTION}>
                <Button className={CLASSES_CANCEL_BUTTON} onClick={props.onClose}>
                    {props.t('Close')}
                </Button>
            </div>
        </div>
    );
};

ExtensionFeatureNeedsAuthModalComponent.propTypes = propTypes;

export const ExtensionFeatureNeedsAuthModal = translate()(ExtensionFeatureNeedsAuthModalComponent);
