import React from 'react';
import PropTypes from 'prop-types';
import { Button } from 'ui/components/buttons/base-button';
import { EXTENSION_PROP_TYPE } from 'state/extensions';

const propTypes = {
    extension: EXTENSION_PROP_TYPE,
    onClick: PropTypes.func,
};

const defaultProps = {
    onClick() { },
};

export class ExtensionListButton extends React.Component {
    constructor() {
        super(...arguments);

        this.handleClick = this.handleClick.bind(this);
    }

    handleClick() {
        this.props.onClick(this.props.extension);
    }

    render() {
        return (
            <Button
                onClick={this.handleClick}
                className="qa-extension-list-button"
            >
                <span>{this.props.extension.name}</span>
            </Button>
        );
    }
}

ExtensionListButton.propTypes = propTypes;
ExtensionListButton.defaultProps = defaultProps;
