import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { translate } from 'react-i18next';
import { EXTENSION_PROP_TYPE } from 'state/extensions';
import { ExtensionListButton } from 'ui/components/extensions/extension-list-button';

const ACTIVE_EXTENSIONS = 'Active Extensions';

const propTypes = {
    extensions: PropTypes.arrayOf(EXTENSION_PROP_TYPE).isRequired,
    onExtensionClick: PropTypes.func,
    t: PropTypes.func.isRequired,
};

const defaultProps = {
    onExtensionClick() {},
};

const CLASSES_ITEM_WITH_CARET = classNames({
    'pl-menu__item': true,
    'pl-menu__item--block': true,
    'pl-menu__item--with-caret': true,
});

const CLASSES_LIST_HEADER = classNames({
    'pl-menu__section': true,
    'pl-menu__item--block': true,
    'pl-menu__item--label': true,
});

const CLASSES_LIST_SECTION = classNames({
    'pl-menu__section': true,
    'pl-menu__section--with-sep': true,
});

export class ExtensionListMenuComponent extends React.Component {
    constructor() {
        super(...arguments);

        this.handleExtensionClick = this.handleExtensionClick.bind(this);
    }

    handleExtensionClick(extension) {
        this.props.onExtensionClick(extension);
    }

    render() {
        const { extensions, t } = this.props;
        const extensionButtons = extensions.map(extension => (
            <div
                className={CLASSES_ITEM_WITH_CARET}
                key={extension.id}
            >
                <ExtensionListButton
                    onClick={this.handleExtensionClick}
                    extension={extension}
                />
            </div>
        ));

        return (
            <div className="pl-menu__inner">
                <div className={CLASSES_LIST_HEADER}>
                    <span>{t(ACTIVE_EXTENSIONS)}</span>
                </div>
                <div className={CLASSES_LIST_SECTION}>
                    {extensionButtons}
                </div>
            </div>
        );
    }
}

ExtensionListMenuComponent.propTypes = propTypes;
ExtensionListMenuComponent.defaultProps = defaultProps;

export const ExtensionListMenu = translate()(ExtensionListMenuComponent);
