import React from 'react';
import PropTypes from 'prop-types';
import { Button } from '../buttons/base-button';
import { Icon } from '../buttons/base-icon';

const propTypes = {
    onClick: PropTypes.func,
    tooltip: PropTypes.string.isRequired,
};

const defaultProps = {
    onClick() {},
};

export const ExtensionSettingsButton = ({ onClick, tooltip }) => {
    return (
        <Button
            onClick={onClick}
            className="player-button"
        >
            <Icon
                label={tooltip}
                labelClass="extension-settings-button__tooltip"
                iconId="#icon_extensions"
                iconClass="pl-settings-icon"
            />
        </Button>
    );
};

ExtensionSettingsButton.propTypes = propTypes;
ExtensionSettingsButton.defaultProps = defaultProps;
