import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { NotificationsButton } from '../buttons/notifications-button';
import classNames from 'classnames';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    enable: PropTypes.func.isRequired,
    disable: PropTypes.func.isRequired,
    notificationsEnabled: PropTypes.bool.isRequired,
    t: PropTypes.func,
};

const defaultProps = {
    t() {},
};

const PANEL_CLASS = classNames(
    'pl-pinned-panel',
    'pl-pinned-panel--embed'
);

const NOTIFICATIONS_BUTTON_CLASS = classNames(
    'pl-button--hollow',
    'pl-mg-t-2'
);

export function CenteredFollowPanelComponent(props) {
    const {
        channelName,
        enable,
        disable,
        notificationsEnabled,
        t,
    } = props;

    return (
        <div className={PANEL_CLASS}>
            <h2 className="pl-pinned-panel__title">
                {t('Live Broadcast has ended')}
            </h2>
            <p className="pl-pinned-panel__subtext">
                {t('Get notified when {{channelName}} goes live next', { channelName })}
            </p>
            <NotificationsButton
                className={NOTIFICATIONS_BUTTON_CLASS}
                enable={enable}
                disable={disable}
                notificationsEnabled={notificationsEnabled}
            />
        </div>
    );
}

CenteredFollowPanelComponent.propTypes = propTypes;
CenteredFollowPanelComponent.defaultProps = defaultProps;

export const CenteredFollowPanel = translate()(CenteredFollowPanelComponent);
