import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { NotificationsButton } from '../buttons/notifications-button';
import classNames from 'classnames';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    enable: PropTypes.func,
    disable: PropTypes.func,
    notificationsEnabled: PropTypes.bool.isRequired,
    t: PropTypes.func,
    withInfo: PropTypes.bool.isRequired,
};

const defaultProps = {
    t() {},
    enable() {},
    disable() {},
};

export function GenericFollowPanelComponent(props) {
    const {
        channelName,
        enable,
        disable,
        notificationsEnabled,
        t,
        withInfo,
    } = props;

    const PANEL_CLASS = classNames({
        'pl-pinned-panel': true,
        'pl-pinned-panel--animate': true,
        'pl-pinned-panel--with-info': withInfo,
    });

    return (
        <div className={PANEL_CLASS}>
            <h2 className="pl-pinned-panel__title">
                {t('Follow and get notified when {{channelName}} is live', { channelName })}
            </h2>
            <NotificationsButton
                enable={enable}
                disable={disable}
                notificationsEnabled={notificationsEnabled}
            />
        </div>
    );
}

GenericFollowPanelComponent.propTypes = propTypes;
GenericFollowPanelComponent.defaultProps = defaultProps;

export const GenericFollowPanel = translate()(GenericFollowPanelComponent);
