import React from 'react';
import PropTypes from 'prop-types';
import { FollowButton } from 'ui/containers/buttons/follow-button';
import { SubscribeButton } from 'ui/containers/buttons/subscribe-button';
import { DEFAULT_AVATAR_URL } from 'settings';
import classNames from 'classnames';

const propTypes = {
    avatarURL: PropTypes.string,
    onFollowChannel: PropTypes.func.isRequired,
    onUnfollowChannel: PropTypes.func.isRequired,
    onSubscribe: PropTypes.func.isRequired,
};

export const TwitchEverywhereFollowPanel = props => {
    const PINNED_PANEL_CLASSES = classNames({
        'pl-pinned-panel': true,
        'pl-pinned-panel--te': true,
    });

    return (
        <div className={PINNED_PANEL_CLASSES}>
            <figure className="pl-pinned-panel__avatar">
                <img
                    src={props.avatarURL || DEFAULT_AVATAR_URL}
                    alt={'Avatar'}
                    height={30}
                    width={30}
                />
            </figure>

            <FollowButton
                onFollowChannel={props.onFollowChannel}
                onUnfollowChannel={props.onUnfollowChannel}
            />

            <SubscribeButton onSubscribe={props.onSubscribe} />
        </div>
    );
};

TwitchEverywhereFollowPanel.propTypes = propTypes;
