import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { NotificationsButton } from '../buttons/notifications-button';
import classNames from 'classnames';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    enable: PropTypes.func.isRequired,
    disable: PropTypes.func.isRequired,
    notificationsEnabled: PropTypes.bool.isRequired,
    t: PropTypes.func,
};

const defaultProps = {
    t() {},
};

const NOTIFICATIONS_BUTTON_CLASS = classNames(
    'pl-button--hollow',
    'pl-mg-t-2'
);

export function UnavailableContentFollowPanelComponent(props) {
    const {
        channelName,
        enable,
        disable,
        notificationsEnabled,
        t,
    } = props;

    return (
        <div>
            <p className="pl-pinned-panel__subtext">
                {t('Get notified when {{channelName}} goes live next', { channelName })}
            </p>
            <NotificationsButton
                className={NOTIFICATIONS_BUTTON_CLASS}
                enable={enable}
                disable={disable}
                notificationsEnabled={notificationsEnabled}
            />
        </div>
    );
}

UnavailableContentFollowPanelComponent.propTypes = propTypes;
UnavailableContentFollowPanelComponent.defaultProps = defaultProps;

export const UnavailableContentFollowPanel = translate()(UnavailableContentFollowPanelComponent);
