import React from 'react';
import PropTypes from 'prop-types';
import { NotificationPopUp } from './notification-popup';
import { translate } from 'react-i18next';
import classNames from 'classnames';
import { localStore } from 'util/storage';
import { AUTO_SUGGEST_NOTIFICATION_CLOSED_COUNT } from './../../../auto-suggest-notification-manager';

const CONTENT_BLOCK_CLASS = classNames({
    'pl-notif__text': true,
});

const CONTENT_SECTION_CLASS = classNames({
    'pl-notif__content': true,
});

// eslint-disable-next-line max-len
const AUTO_SUGGEST_NOTIFICATION_MESSAGE = 'Is your video buffering? Try the auto quality option.';

const propTypes = {
    t: PropTypes.func.isRequired,
    onClose: PropTypes.func.isRequired,
};

export class AutoSuggestNotificationComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.handleClose = this.handleClose.bind(this);
    }

    render() {
        const { t } = this.props;

        return (
            <NotificationPopUp
                onClose={this.handleClose}
            >
                <div className={CONTENT_SECTION_CLASS}>
                    <p className={CONTENT_BLOCK_CLASS}>
                        {t(AUTO_SUGGEST_NOTIFICATION_MESSAGE)}
                    </p>
                </div>
            </NotificationPopUp>
        );
    }

    handleClose() {
        if (!localStore.get(AUTO_SUGGEST_NOTIFICATION_CLOSED_COUNT)) {
            localStore.set(AUTO_SUGGEST_NOTIFICATION_CLOSED_COUNT, 1);
        } else {
            const currentCount = localStore.get(AUTO_SUGGEST_NOTIFICATION_CLOSED_COUNT);
            localStore.set(AUTO_SUGGEST_NOTIFICATION_CLOSED_COUNT, currentCount + 1);
        }

        const onCloseProp = this.props.onClose;
        if (onCloseProp) {
            onCloseProp(...arguments);
        }
    }
}

AutoSuggestNotificationComponent.propTypes = propTypes;

export const AutoSuggestNotification = translate()(AutoSuggestNotificationComponent);
